<?php
/**
 * SEOAuto Uninstall
 *
 * Fired when the plugin is uninstalled.
 *
 * @package SEOAuto
 */

// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

/**
 * Remove plugin data on uninstall.
 *
 * Note: This only runs when the plugin is DELETED, not deactivated.
 */

global $wpdb;

// Remove custom tables.
$seoauto_tables = array(
    $wpdb->prefix . 'seoauto_articles',
    $wpdb->prefix . 'seoauto_logs',
);

foreach ( $seoauto_tables as $seoauto_table ) {
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $wpdb->query( "DROP TABLE IF EXISTS {$seoauto_table}" );
}

// Remove all plugin options.
$seoauto_options = array(
    'seoauto_api_key',
    'seoauto_site_id',
    'seoauto_connected_at',
    'seoauto_default_category',
    'seoauto_default_author',
    'seoauto_post_status',
    'seoauto_auto_publish',
    'seoauto_include_youtube',
    'seoauto_include_infographic',
    'seoauto_infographic_position',
    'seoauto_debug_mode',
    'seoauto_sync_interval',
    'seoauto_last_sync',
    'seoauto_db_version',
    'seoauto_activation_time',
    'seoauto_setup_complete',
);

foreach ( $seoauto_options as $seoauto_option ) {
    delete_option( $seoauto_option );
}

// Remove all transients
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query(
    "DELETE FROM {$wpdb->options}
    WHERE option_name LIKE '_transient_seoauto_%'
    OR option_name LIKE '_transient_timeout_seoauto_%'"
);

// For multisite, remove site transients
if ( is_multisite() ) {
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
    $wpdb->query(
        "DELETE FROM {$wpdb->sitemeta}
        WHERE meta_key LIKE '_site_transient_seoauto_%'
        OR meta_key LIKE '_site_transient_timeout_seoauto_%'"
    );
}

// Remove all post meta related to SEOAuto
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query(
    "DELETE FROM {$wpdb->postmeta}
    WHERE meta_key LIKE '_seoauto_%'"
);

// Clear any scheduled cron events (safety measure)
wp_clear_scheduled_hook( 'seoauto_auto_sync' );
wp_clear_scheduled_hook( 'seoauto_cleanup' );
wp_clear_scheduled_hook( 'seoauto_health_check' );

// Fire uninstall action for other plugins/themes to hook into
do_action( 'seoauto_uninstalled' );
