<?php
/**
 * Settings Template
 *
 * @package SEOAuto\Plugin
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Get plugin instance for connection status.
$seoauto_plugin = \SEOAuto\Plugin\Plugin::get_instance();

// Get current settings.
$seoauto_api_key          = get_option( 'seoauto_api_key', '' );
$seoauto_site_id          = get_option( 'seoauto_site_id', '' );
$seoauto_website_name     = get_option( 'seoauto_website_name', '' );
$seoauto_website_url      = get_option( 'seoauto_website_url', '' );
$seoauto_is_connected     = $seoauto_plugin->is_connected(); // Uses real connection status.
$seoauto_connection_error = $seoauto_plugin->get_connection_error();
$seoauto_default_category = get_option( 'seoauto_default_category', 1 );
$seoauto_default_author   = get_option( 'seoauto_default_author', 1 );
$seoauto_debug_mode       = get_option( 'seoauto_debug_mode', false );

// Get categories for dropdown.
$seoauto_categories = get_categories( array( 'hide_empty' => false ) );

// Get authors for dropdown.
$seoauto_authors = get_users( array( 'who' => 'authors' ) );
if ( empty( $seoauto_authors ) ) {
    $seoauto_authors = get_users( array( 'role__in' => array( 'administrator', 'editor', 'author' ) ) );
}
?>

<div class="wrap seoauto-settings">
    <h1 class="wp-heading-inline">SEOAuto Settings</h1>
    <hr class="wp-header-end">

    <?php settings_errors( 'seoauto_messages' ); ?>

    <!-- Modern Tabs -->
    <div class="seoauto-settings-tabs">
        <a href="#" class="seoauto-settings-tab active" data-tab="connection">
            <span class="dashicons dashicons-admin-network"></span>
            API Configuration
        </a>
        <a href="#" class="seoauto-settings-tab" data-tab="publishing">
            <span class="dashicons dashicons-edit-page"></span>
            Publishing
        </a>
        <a href="#" class="seoauto-settings-tab" data-tab="advanced">
            <span class="dashicons dashicons-admin-tools"></span>
            Advanced
        </a>
    </div>

    <form method="post" action="options.php">
        <?php settings_fields( \SEOAuto\Plugin\Admin\SettingsPage::get_option_group() ); ?>

        <!-- API Configuration Tab -->
        <div class="seoauto-settings-panel active" id="panel-connection">
            <div class="seoauto-card">
                <div class="seoauto-card-header">
                    <h2>API Configuration</h2>
                </div>
                <div class="seoauto-card-body">
                    <div class="seoauto-settings-field">
                        <label for="seoauto_api_key">API Key</label>
                        <div class="seoauto-api-input-wrapper">
                            <div class="seoauto-api-input-container">
                                <input type="password"
                                       id="seoauto_api_key"
                                       name="seoauto_api_key"
                                       value="<?php echo esc_attr( $seoauto_api_key ); ?>"
                                       placeholder="Enter your API key"
                                       autocomplete="off" />
                                <button type="button" id="toggle-key" class="seoauto-icon-btn" title="Show/Hide">
                                    <span class="dashicons dashicons-visibility"></span>
                                </button>
                            </div>
                            <button type="button" id="test-connection" class="seoauto-btn seoauto-btn-secondary">
                                <span class="dashicons dashicons-yes-alt"></span>
                                Test Connection
                            </button>
                        </div>
                        <div id="seoauto-message" class="seoauto-inline-msg"></div>
                        <p class="seoauto-field-description">
                            Get your API key from the <a href="https://app.seoauto.io/settings/wordpress" target="_blank">SEOAuto Dashboard</a>.
                        </p>
                    </div>

                    <!-- Connection Status -->
                    <?php if ( $seoauto_is_connected ) : ?>
                        <div class="seoauto-connection-box connected">
                            <div class="seoauto-connection-icon">
                                <span class="dashicons dashicons-yes-alt"></span>
                            </div>
                            <div class="seoauto-connection-details">
                                <strong>Connected to SEOAuto</strong>
                                <?php if ( $seoauto_website_url ) : ?>
                                    <span class="seoauto-connected-site">
                                        <span class="dashicons dashicons-admin-site-alt3"></span>
                                        <?php echo esc_html( $seoauto_website_url ); ?>
                                    </span>
                                <?php elseif ( $seoauto_website_name ) : ?>
                                    <span class="seoauto-connected-site">
                                        <span class="dashicons dashicons-admin-site-alt3"></span>
                                        <?php echo esc_html( $seoauto_website_name ); ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php else : ?>
                        <div class="seoauto-connection-box disconnected <?php echo $seoauto_connection_error ? 'error' : ''; ?>">
                            <div class="seoauto-connection-icon">
                                <span class="dashicons dashicons-<?php echo $seoauto_connection_error ? 'dismiss' : 'warning'; ?>"></span>
                            </div>
                            <div class="seoauto-connection-details">
                                <?php if ( $seoauto_connection_error ) : ?>
                                    <strong>Connection Failed</strong>
                                    <span class="seoauto-error-msg"><?php echo esc_html( $seoauto_connection_error ); ?></span>
                                <?php elseif ( ! empty( $seoauto_api_key ) ) : ?>
                                    <strong>Not Validated</strong>
                                    <span>Click Test Connection to validate your API key.</span>
                                <?php else : ?>
                                    <strong>Not Connected</strong>
                                    <span>Enter your API key and click Test Connection to get started.</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Publishing Tab -->
        <div class="seoauto-settings-panel" id="panel-publishing">
            <div class="seoauto-card">
                <div class="seoauto-card-header">
                    <h2>Publishing Settings</h2>
                </div>
                <div class="seoauto-card-body">
                    <div class="seoauto-settings-field">
                        <label for="seoauto_default_category">Default Category</label>
                        <select id="seoauto_default_category" name="seoauto_default_category">
                            <?php foreach ( $seoauto_categories as $seoauto_category ) : ?>
                                <option value="<?php echo esc_attr( $seoauto_category->term_id ); ?>" <?php selected( $seoauto_default_category, $seoauto_category->term_id ); ?>>
                                    <?php echo esc_html( $seoauto_category->name ); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <p class="seoauto-field-description">Articles will be assigned to this category by default.</p>
                    </div>

                    <div class="seoauto-settings-field">
                        <label for="seoauto_default_author">Default Author</label>
                        <select id="seoauto_default_author" name="seoauto_default_author">
                            <?php foreach ( $seoauto_authors as $seoauto_author ) : ?>
                                <option value="<?php echo esc_attr( $seoauto_author->ID ); ?>" <?php selected( $seoauto_default_author, $seoauto_author->ID ); ?>>
                                    <?php echo esc_html( $seoauto_author->display_name ); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <p class="seoauto-field-description">Articles will be published under this author.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Advanced Tab -->
        <div class="seoauto-settings-panel" id="panel-advanced">
            <div class="seoauto-card">
                <div class="seoauto-card-header">
                    <h2>System Information</h2>
                </div>
                <div class="seoauto-card-body">
                    <table class="seoauto-info-table">
                        <tr>
                            <th>Plugin Version</th>
                            <td><?php echo esc_html( SEOAUTO_VERSION ); ?></td>
                        </tr>
                        <tr>
                            <th>WordPress Version</th>
                            <td><?php echo esc_html( get_bloginfo( 'version' ) ); ?></td>
                        </tr>
                        <tr>
                            <th>PHP Version</th>
                            <td><?php echo esc_html( PHP_VERSION ); ?></td>
                        </tr>
                        <tr>
                            <th>Site URL</th>
                            <td><code><?php echo esc_html( get_site_url() ); ?></code></td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="seoauto-card">
                <div class="seoauto-card-header">
                    <h2>Debug & Maintenance</h2>
                </div>
                <div class="seoauto-card-body">
                    <div class="seoauto-settings-field">
                        <label class="seoauto-checkbox-wrapper">
                            <input type="checkbox"
                                   id="seoauto_debug_mode"
                                   name="seoauto_debug_mode"
                                   value="1"
                                   <?php checked( $seoauto_debug_mode ); ?> />
                            <span class="seoauto-checkbox-label">
                                <strong>Enable debug logging</strong>
                                <span>When enabled, detailed logs will be recorded for troubleshooting.</span>
                            </span>
                        </label>
                    </div>

                    <div class="seoauto-danger-section">
                        <h4>Danger Zone</h4>
                        <button type="button" id="reset-plugin" class="seoauto-btn seoauto-btn-danger">
                            <span class="dashicons dashicons-trash"></span>
                            Reset Plugin
                        </button>
                        <p class="seoauto-field-description">
                            Reset will clear all settings and disconnect from SEOAuto. Published articles will not be affected.
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="seoauto-settings-submit">
            <button type="submit" class="seoauto-btn seoauto-btn-primary seoauto-btn-lg">
                <span class="dashicons dashicons-saved"></span>
                Save Settings
            </button>
        </div>
    </form>
</div>
