<?php
/**
 * Dashboard Template
 *
 * @package SEOAuto\Plugin
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Get plugin instance.
$seoauto_plugin = \SEOAuto\Plugin\Plugin::get_instance();

// Get connection status.
$seoauto_is_connected     = $seoauto_plugin->is_connected();
$seoauto_connection_error = $seoauto_plugin->get_connection_error();
$seoauto_api_key          = $seoauto_plugin->get_api_key();
$seoauto_site_id          = get_option( 'seoauto_site_id', '' );
$seoauto_connected_at     = get_option( 'seoauto_connected_at', '' );
$seoauto_last_sync        = get_option( 'seoauto_last_sync', '' );

// Get article statistics.
global $wpdb;
$seoauto_articles_table = $wpdb->prefix . 'seoauto_articles';
$seoauto_stats          = array(
    'total'     => 0,
    'published' => 0,
    'pending'   => 0,
    'failed'    => 0,
);

// Check if table exists and get stats.
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Table check.
if ( $wpdb->get_var( $wpdb->prepare( 'SHOW TABLES LIKE %s', $seoauto_articles_table ) ) === $seoauto_articles_table ) {
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Stats query.
    $seoauto_counts = $wpdb->get_results(
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter -- Table name from $wpdb->prefix.
        "SELECT status, COUNT(*) as count FROM {$seoauto_articles_table} GROUP BY status",
        ARRAY_A
    );

    foreach ( $seoauto_counts as $seoauto_row ) {
        if ( isset( $seoauto_stats[ $seoauto_row['status'] ] ) ) {
            $seoauto_stats[ $seoauto_row['status'] ] = (int) $seoauto_row['count'];
        }
        $seoauto_stats['total'] += (int) $seoauto_row['count'];
    }

    // Get recent articles.
    // phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
    $seoauto_recent_articles = $wpdb->get_results(
        "SELECT a.*, p.post_title as wp_title
        FROM {$seoauto_articles_table} a
        LEFT JOIN {$wpdb->posts} p ON a.post_id = p.ID
        ORDER BY a.synced_at DESC
        LIMIT 5",
        ARRAY_A
    );
    // phpcs:enable
} else {
    $seoauto_recent_articles = array();
}

// Get SEO plugin info.
$seoauto_seo_integration = new \SEOAuto\Plugin\Publisher\SeoIntegration();
$seoauto_active_seo      = $seoauto_seo_integration->get_active_seo_plugin();
?>

<div class="wrap seoauto-dashboard">
    <h1 class="wp-heading-inline">
        <span class="seoauto-logo"></span>
        <?php esc_html_e( 'SEOAuto Dashboard', 'seoauto-ai-content-publisher' ); ?>
    </h1>

    <hr class="wp-header-end">

    <?php settings_errors( 'seoauto_messages' ); ?>

    <!-- Connection Status Card -->
    <div class="seoauto-card seoauto-connection-card <?php echo $seoauto_is_connected ? 'connected' : ( $seoauto_connection_error ? 'error' : 'disconnected' ); ?>">
        <div class="seoauto-card-header">
            <h2><?php esc_html_e( 'Connection Status', 'seoauto-ai-content-publisher' ); ?></h2>
        </div>
        <div class="seoauto-card-body">
            <div class="seoauto-status-indicator">
                <span class="seoauto-status-dot <?php echo $seoauto_is_connected ? 'online' : ( $seoauto_connection_error ? 'error' : 'offline' ); ?>"></span>
                <span class="seoauto-status-text">
                    <?php
                    if ( $seoauto_is_connected ) {
                        esc_html_e( 'Connected to SEOAuto', 'seoauto-ai-content-publisher' );
                    } elseif ( $seoauto_connection_error ) {
                        esc_html_e( 'Connection Failed', 'seoauto-ai-content-publisher' );
                    } else {
                        esc_html_e( 'Not Connected', 'seoauto-ai-content-publisher' );
                    }
                    ?>
                </span>
            </div>

            <?php if ( $seoauto_is_connected ) : ?>
                <div class="seoauto-connection-info">
                    <p>
                        <strong><?php esc_html_e( 'Site ID:', 'seoauto-ai-content-publisher' ); ?></strong>
                        <code><?php echo esc_html( $seoauto_site_id ); ?></code>
                    </p>
                    <?php if ( $seoauto_connected_at ) : ?>
                        <p>
                            <strong><?php esc_html_e( 'Connected:', 'seoauto-ai-content-publisher' ); ?></strong>
                            <?php echo esc_html( human_time_diff( strtotime( $seoauto_connected_at ), time() ) ); ?>
                            <?php esc_html_e( 'ago', 'seoauto-ai-content-publisher' ); ?>
                        </p>
                    <?php endif; ?>
                    <?php if ( $seoauto_last_sync ) : ?>
                        <p>
                            <strong><?php esc_html_e( 'Last Sync:', 'seoauto-ai-content-publisher' ); ?></strong>
                            <?php echo esc_html( human_time_diff( strtotime( $seoauto_last_sync ), time() ) ); ?>
                            <?php esc_html_e( 'ago', 'seoauto-ai-content-publisher' ); ?>
                        </p>
                    <?php endif; ?>
                    <?php if ( $seoauto_active_seo ) : ?>
                        <p>
                            <strong><?php esc_html_e( 'SEO Plugin:', 'seoauto-ai-content-publisher' ); ?></strong>
                            <?php echo esc_html( $seoauto_active_seo ); ?>
                        </p>
                    <?php endif; ?>
                </div>
            <?php elseif ( $seoauto_connection_error ) : ?>
                <div class="seoauto-connection-error">
                    <p class="seoauto-error-message">
                        <span class="dashicons dashicons-warning"></span>
                        <?php echo esc_html( $seoauto_connection_error ); ?>
                    </p>
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=seoauto-settings' ) ); ?>" class="button button-primary">
                        <?php esc_html_e( 'Fix Connection', 'seoauto-ai-content-publisher' ); ?>
                    </a>
                </div>
            <?php else : ?>
                <p class="seoauto-setup-prompt">
                    <?php esc_html_e( 'Connect your site to start receiving AI-generated SEO articles.', 'seoauto-ai-content-publisher' ); ?>
                </p>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=seoauto-settings' ) ); ?>" class="button button-primary">
                    <?php esc_html_e( 'Configure API Key', 'seoauto-ai-content-publisher' ); ?>
                </a>
            <?php endif; ?>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="seoauto-stats-grid">
        <div class="seoauto-stat-card">
            <div class="seoauto-stat-icon total"></div>
            <div class="seoauto-stat-content">
                <span class="seoauto-stat-number"><?php echo esc_html( $seoauto_stats['total'] ); ?></span>
                <span class="seoauto-stat-label"><?php esc_html_e( 'Total Articles', 'seoauto-ai-content-publisher' ); ?></span>
            </div>
        </div>

        <div class="seoauto-stat-card">
            <div class="seoauto-stat-icon published"></div>
            <div class="seoauto-stat-content">
                <span class="seoauto-stat-number"><?php echo esc_html( $seoauto_stats['published'] ); ?></span>
                <span class="seoauto-stat-label"><?php esc_html_e( 'Published', 'seoauto-ai-content-publisher' ); ?></span>
            </div>
        </div>

        <div class="seoauto-stat-card">
            <div class="seoauto-stat-icon pending"></div>
            <div class="seoauto-stat-content">
                <span class="seoauto-stat-number"><?php echo esc_html( $seoauto_stats['pending'] ); ?></span>
                <span class="seoauto-stat-label"><?php esc_html_e( 'Pending', 'seoauto-ai-content-publisher' ); ?></span>
            </div>
        </div>

        <div class="seoauto-stat-card">
            <div class="seoauto-stat-icon failed"></div>
            <div class="seoauto-stat-content">
                <span class="seoauto-stat-number"><?php echo esc_html( $seoauto_stats['failed'] ); ?></span>
                <span class="seoauto-stat-label"><?php esc_html_e( 'Failed', 'seoauto-ai-content-publisher' ); ?></span>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <?php if ( $seoauto_is_connected ) : ?>
        <div class="seoauto-card seoauto-actions-card">
            <div class="seoauto-card-header">
                <h2><?php esc_html_e( 'Quick Actions', 'seoauto-ai-content-publisher' ); ?></h2>
            </div>
            <div class="seoauto-card-body">
                <div class="seoauto-actions-row">
                    <button type="button" id="seoauto-sync-now" class="button button-primary">
                        <span class="dashicons dashicons-update"></span>
                        <?php esc_html_e( 'Sync Now', 'seoauto-ai-content-publisher' ); ?>
                    </button>

                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=seoauto-articles' ) ); ?>" class="button">
                        <span class="dashicons dashicons-media-text"></span>
                        <?php esc_html_e( 'View All Articles', 'seoauto-ai-content-publisher' ); ?>
                    </a>

                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=seoauto-settings' ) ); ?>" class="button">
                        <span class="dashicons dashicons-admin-settings"></span>
                        <?php esc_html_e( 'Settings', 'seoauto-ai-content-publisher' ); ?>
                    </a>
                </div>
                <div id="seoauto-sync-message" class="seoauto-message" style="display: none;"></div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Recent Articles -->
    <?php if ( ! empty( $seoauto_recent_articles ) ) : ?>
        <div class="seoauto-card seoauto-recent-card">
            <div class="seoauto-card-header">
                <h2><?php esc_html_e( 'Recent Articles', 'seoauto-ai-content-publisher' ); ?></h2>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=seoauto-articles' ) ); ?>" class="seoauto-view-all">
                    <?php esc_html_e( 'View All', 'seoauto-ai-content-publisher' ); ?> &rarr;
                </a>
            </div>
            <div class="seoauto-card-body">
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'Title', 'seoauto-ai-content-publisher' ); ?></th>
                            <th width="100"><?php esc_html_e( 'Status', 'seoauto-ai-content-publisher' ); ?></th>
                            <th width="150"><?php esc_html_e( 'Synced', 'seoauto-ai-content-publisher' ); ?></th>
                            <th width="100"><?php esc_html_e( 'Actions', 'seoauto-ai-content-publisher' ); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ( $seoauto_recent_articles as $seoauto_article ) : ?>
                            <tr>
                                <td>
                                    <?php if ( ! empty( $seoauto_article['post_id'] ) ) : ?>
                                        <a href="<?php echo esc_url( get_edit_post_link( $seoauto_article['post_id'] ) ); ?>">
                                            <?php echo esc_html( $seoauto_article['wp_title'] ?: $seoauto_article['title'] ); ?>
                                        </a>
                                    <?php else : ?>
                                        <?php echo esc_html( $seoauto_article['title'] ); ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="seoauto-status-badge <?php echo esc_attr( $seoauto_article['status'] ); ?>">
                                        <?php echo esc_html( ucfirst( $seoauto_article['status'] ) ); ?>
                                    </span>
                                </td>
                                <td>
                                    <?php
                                    if ( $seoauto_article['synced_at'] ) {
                                        echo esc_html( human_time_diff( strtotime( $seoauto_article['synced_at'] ), time() ) );
                                        esc_html_e( ' ago', 'seoauto-ai-content-publisher' );
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php if ( ! empty( $seoauto_article['post_id'] ) ) : ?>
                                        <a href="<?php echo esc_url( get_permalink( $seoauto_article['post_id'] ) ); ?>" target="_blank" title="<?php esc_attr_e( 'View', 'seoauto-ai-content-publisher' ); ?>">
                                            <span class="dashicons dashicons-visibility"></span>
                                        </a>
                                        <a href="<?php echo esc_url( get_edit_post_link( $seoauto_article['post_id'] ) ); ?>" title="<?php esc_attr_e( 'Edit', 'seoauto-ai-content-publisher' ); ?>">
                                            <span class="dashicons dashicons-edit"></span>
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>

    <!-- System Info -->
    <div class="seoauto-card seoauto-info-card">
        <div class="seoauto-card-header">
            <h2><?php esc_html_e( 'System Information', 'seoauto-ai-content-publisher' ); ?></h2>
        </div>
        <div class="seoauto-card-body">
            <table class="seoauto-info-table">
                <tr>
                    <th><?php esc_html_e( 'Plugin Version', 'seoauto-ai-content-publisher' ); ?></th>
                    <td><?php echo esc_html( SEOAUTO_VERSION ); ?></td>
                </tr>
                <tr>
                    <th><?php esc_html_e( 'WordPress Version', 'seoauto-ai-content-publisher' ); ?></th>
                    <td><?php echo esc_html( get_bloginfo( 'version' ) ); ?></td>
                </tr>
                <tr>
                    <th><?php esc_html_e( 'PHP Version', 'seoauto-ai-content-publisher' ); ?></th>
                    <td><?php echo esc_html( PHP_VERSION ); ?></td>
                </tr>
                <tr>
                    <th><?php esc_html_e( 'REST API Endpoint', 'seoauto-ai-content-publisher' ); ?></th>
                    <td><code><?php echo esc_html( rest_url( 'seoauto/v1/' ) ); ?></code></td>
                </tr>
                <tr>
                    <th><?php esc_html_e( 'Debug Mode', 'seoauto-ai-content-publisher' ); ?></th>
                    <td>
                        <?php if ( $seoauto_plugin->is_debug_mode() ) : ?>
                            <span class="seoauto-badge enabled"><?php esc_html_e( 'Enabled', 'seoauto-ai-content-publisher' ); ?></span>
                        <?php else : ?>
                            <span class="seoauto-badge disabled"><?php esc_html_e( 'Disabled', 'seoauto-ai-content-publisher' ); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
            </table>
        </div>
    </div>
</div>
