<?php
/**
 * Articles List Template
 *
 * @package SEOAuto\Plugin
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Create an instance of our table class.
$seoauto_list_table = new \SEOAuto\Plugin\Admin\ArticlesTable();
$seoauto_list_table->prepare_items();

// Check for messages.
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only success message.
$seoauto_deleted_count = isset( $_GET['deleted'] ) ? absint( $_GET['deleted'] ) : 0;
?>

<div class="wrap seoauto-articles">
    <h1 class="wp-heading-inline">
        <?php esc_html_e( 'SEOAuto Articles', 'seoauto-ai-content-publisher' ); ?>
    </h1>

    <a href="<?php echo esc_url( admin_url( 'admin.php?page=seoauto' ) ); ?>" class="page-title-action">
        <?php esc_html_e( 'Dashboard', 'seoauto-ai-content-publisher' ); ?>
    </a>

    <hr class="wp-header-end">

    <?php if ( $seoauto_deleted_count > 0 ) : ?>
        <div class="notice notice-success is-dismissible">
            <p>
                <?php
                printf(
                    /* translators: %d: Number of articles deleted */
                    esc_html( _n( '%d article deleted.', '%d articles deleted.', $seoauto_deleted_count, 'seoauto-ai-content-publisher' ) ),
                    esc_html( $seoauto_deleted_count )
                );
                ?>
            </p>
        </div>
    <?php endif; ?>

    <?php settings_errors( 'seoauto_messages' ); ?>

    <!-- Views (Status filters) -->
    <?php $seoauto_list_table->views(); ?>

    <form method="get" id="seoauto-articles-filter">
        <input type="hidden" name="page" value="seoauto-articles" />

        <?php
        // phpcs:disable WordPress.Security.NonceVerification.Recommended -- Read-only filter for preserving status in form submission.
        if ( ! empty( $_GET['status'] ) ) :
            $seoauto_status_filter = sanitize_text_field( wp_unslash( $_GET['status'] ) );
        ?>
            <input type="hidden" name="status" value="<?php echo esc_attr( $seoauto_status_filter ); ?>" />
        <?php endif; ?>
        <?php // phpcs:enable ?>

        <!-- Search Box -->
        <?php $seoauto_list_table->search_box( __( 'Search Articles', 'seoauto-ai-content-publisher' ), 'seoauto-article-search' ); ?>

        <!-- The Table -->
        <?php $seoauto_list_table->display(); ?>
    </form>

    <!-- Legend -->
    <div class="seoauto-legend">
        <h4><?php esc_html_e( 'Status Legend', 'seoauto-ai-content-publisher' ); ?></h4>
        <ul>
            <li>
                <span class="seoauto-status-badge published"><?php esc_html_e( 'Published', 'seoauto-ai-content-publisher' ); ?></span>
                <?php esc_html_e( 'Article is live on your site', 'seoauto-ai-content-publisher' ); ?>
            </li>
            <li>
                <span class="seoauto-status-badge pending"><?php esc_html_e( 'Pending', 'seoauto-ai-content-publisher' ); ?></span>
                <?php esc_html_e( 'Article received but not yet published', 'seoauto-ai-content-publisher' ); ?>
            </li>
            <li>
                <span class="seoauto-status-badge failed"><?php esc_html_e( 'Failed', 'seoauto-ai-content-publisher' ); ?></span>
                <?php esc_html_e( 'Publishing failed - check logs for details', 'seoauto-ai-content-publisher' ); ?>
            </li>
            <li>
                <span class="seoauto-status-badge deleted"><?php esc_html_e( 'Deleted', 'seoauto-ai-content-publisher' ); ?></span>
                <?php esc_html_e( 'Article was deleted or trashed', 'seoauto-ai-content-publisher' ); ?>
            </li>
        </ul>
    </div>
</div>
