# Changelog

All notable changes to SEOAuto AI Content Publisher will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [1.0.5] - 2026-01-11

### Changed
- Simplified settings page from 4 tabs to 3 tabs
- Settings now match competitor's simple design approach
- Tab 1: API Configuration (API key + Test Connection)
- Tab 2: Publishing (Default Category + Default Author only)
- Tab 3: Advanced (System Info + Debug Mode + Reset)

### Removed
- Content tab (YouTube Videos, Infographics settings)
- Post Status option (removed from Publishing)
- Auto-Publish option (removed from Publishing)
- Sync Interval option (removed from Advanced)
- Clear Cache button (removed from Advanced)


## [1.0.4] - 2026-01-11

### Changed
- Final rebranding to SEOAuto (seoauto.io)
- Plugin slug: `seoauto-ai`
- Namespace: `SEOAuto\Plugin`
- Constants: `SEOAUTO_*`
- Text domain: `seoauto-ai`
- API base URL: `https://api.seoauto.io`

## [1.0.3] - 2026-01-11

### Changed
- Interim rebranding (later finalized as SEOAuto)

## [1.0.2] - 2026-01-11

### Fixed
- Disabled SSL verification for localhost development connections
- Improved API client compatibility with local development environments

## [1.0.1] - 2026-01-11

### Added
- Automatic versioning system with `bin/version.sh` script
- Production build script with `bin/build.sh`
- CHANGELOG.md with Keep a Changelog format
- VERSION file as single source of truth
- .gitignore for development artifacts

### Changed
- Admin menu now uses custom icon instead of dashicon

## [1.0.0] - 2025-01-11

### Added
- Initial release of SEOAuto AI Content Publisher
- API key authentication with SEOAuto backend
- Admin dashboard with connection status
- Articles list view with status tracking
- Settings page for plugin configuration
- Automatic article sync from SEOAuto
- Support for article metadata (title, content, excerpt, meta description)
- Focus keyword and meta keywords support
- Featured image URL handling
- Tags and categories support
- Custom post status handling
- Cron-based sync scheduler
- Manual sync functionality
- Debug logging system
- Multilingual support with text domain
- WordPress 6.0+ compatibility
- PHP 7.4+ compatibility

### Security
- API key stored securely with WordPress options API
- All API communications over HTTPS
- Input sanitization and output escaping
- Capability checks on all admin pages

[Unreleased]: https://github.com/seoauto/wordpress-plugin/compare/v1.0.4...HEAD
[1.0.4]: https://github.com/seoauto/wordpress-plugin/compare/v1.0.3...v1.0.4
[1.0.3]: https://github.com/seoauto/wordpress-plugin/compare/v1.0.2...v1.0.3
[1.0.2]: https://github.com/seoauto/wordpress-plugin/compare/v1.0.1...v1.0.2
[1.0.1]: https://github.com/seoauto/wordpress-plugin/compare/v1.0.0...v1.0.1
[1.0.0]: https://github.com/seoauto/wordpress-plugin/releases/tag/v1.0.0
